/*
 * Fecha 02/07/2010  
 */
 
package com.ejie.p06b.servlet.DEC;

import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BPaginas;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.servlet.P06BServletGenerico;
import com.ejie.p06b.util.P06BFieldsValidations;
import com.ejie.p06b.util.P06BResources;


/**
 *  Esta clase gestiona las peticiones HTTP de la aplicacin.
 */
public class P06BDECBuscarServlet extends P06BServletGenerico 
{

	//Cambia de idioma en la sesin -> Perfil
	public void ejecutar(HttpServletRequest request, HttpServletResponse response) {
		try {
			if(request.getParameter("accion")==null 
					|| request.getParameter("accion").equals("limpiar")){
				//Si vengo del men o doy a limpiar -> RESETEO TODOS LOS VALORES 
				//Cuando damos al BUSCAR DEC en el men entro por este servlet
				//Por tanto debo resetear todas las variables de sesin de la aplicacin para optimizar espacio.
				//El parmetro fromMenu no lo tengo en cuenta en este caso (Si en el caso del alta por ej.)
				this.deleteAllTempFromSession(request);
			}else if (request.getParameter("accion").equals("buscarDEC")){
					if(this.validate(request,response)){
						//Debo construir el filtro y pasarselo al servlet listado que sabr lo que debe hacer.
						String filtro = this.obtenerFiltro(request);
						request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"DEC"+P06BConstantes.P06B_VAR_TEMP_FILTRO,filtro);
						
						//Aadir a sesin los parmetros de la bsqueda para que no se pierdan			
						request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"ejercicio_busquedaDEC"+P06BConstantes.P06B_VAR_TEMP_FILTRO,(request.getParameter("Ejercicio")==null?"":request.getParameter("Ejercicio")));
						request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"numExp_busquedaDEC"+P06BConstantes.P06B_VAR_TEMP_FILTRO,(request.getParameter("NumExp")==null?"":request.getParameter("NumExp")));
						request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"tipoPersona_busquedaDEC"+P06BConstantes.P06B_VAR_TEMP_FILTRO,(request.getParameter("TipoPersona")==null?"":request.getParameter("TipoPersona")));
						request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"razSoc_busquedaDEC"+P06BConstantes.P06B_VAR_TEMP_FILTRO,(request.getParameter("RazSoc")==null?"":request.getParameter("RazSoc")));
						request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"DNI_busquedaDEC"+P06BConstantes.P06B_VAR_TEMP_FILTRO,(request.getParameter("DNI")==null?"":request.getParameter("DNI")));
						request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"nombre_busquedaDEC"+P06BConstantes.P06B_VAR_TEMP_FILTRO,(request.getParameter("Nombre")==null?"":request.getParameter("Nombre")));
						request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"ape1_busquedaDEC"+P06BConstantes.P06B_VAR_TEMP_FILTRO,(request.getParameter("Ape1")==null?"":request.getParameter("Ape1")));
						request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"ape2_busquedaDEC"+P06BConstantes.P06B_VAR_TEMP_FILTRO,(request.getParameter("Ape2")==null?"":request.getParameter("Ape2")));
								
						forward (request, response, P06BPaginas.P06B_JSP_SERVLETDECLISTADO);
						return;
					}
			}
			//Redireccionamos a la pgina de buscar DEC
			forward (request, response, P06BPaginas.P06B_JSP_DEC_BUSCAR);
		}catch (Exception e){
	      	manejarErrores (request, response, e);
	        return;
	    }
	}
	
	//Validamos campos del formulario
	private boolean validate(HttpServletRequest request, HttpServletResponse response) throws Exception {
		ArrayList errors = new ArrayList();
		boolean resultado = true;
		String idioma = this.getIdioma(request,response);
		//Con la informacin obtenida realizo las validaciones
		P06BResources res = (P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS); 
		
		//1. Campo Ejercicio -> Entero
		errors=P06BFieldsValidations.validation(errors,P06BFieldsValidations.ENTERO,res.get("pantallas.literal.ejercicio"),request.getParameter("Ejercicio"),idioma);
		
		//Comprobamos que haya algn error
		if(!errors.isEmpty())
			resultado = false;
		request.setAttribute("errors",errors);
		return resultado;
	}
	
	//Obtenemos el filtro para obtener y gestionar el listado
	private String obtenerFiltro(HttpServletRequest request) throws Exception {
		String filtro = "";
		boolean primero = true;
		
		String ejercicio = (request.getParameter("Ejercicio")==null)?"":request.getParameter("Ejercicio");
		String numExp = (request.getParameter("NumExp")==null)?"":request.getParameter("NumExp");
		String tipoPersona = (request.getParameter("TipoPersona")==null)?"":request.getParameter("TipoPersona");
		String dni = (request.getParameter("DNI")==null)?"":request.getParameter("DNI");
		String razsoc = (request.getParameter("RazSoc")==null)?"":request.getParameter("RazSoc");
		String nombre = (request.getParameter("Nombre")==null)?"":request.getParameter("Nombre");
		String ape1 = (request.getParameter("Ape1")==null)?"":request.getParameter("Ape1");
		String ape2 = (request.getParameter("Ape2")==null)?"":request.getParameter("Ape2");
		
		if(!ejercicio.equals("")){
			if(!primero)
				filtro+=" AND ";
			else{ 
				primero = false;
				filtro+="WHERE ";
			}
			filtro+= P06BTablas.P06B_P06B32_EJERCICIO + " LIKE '%"+ejercicio.toUpperCase()+"%'";
		}
		if(!numExp.equals("")){
			if(!primero)
				filtro+=" AND ";
			else{ 
				primero = false;
				filtro+="WHERE ";
			}
			filtro+= "UPPER(" + P06BTablas.P06B_P06B32_NUMEXP + ") LIKE '%"+numExp.toUpperCase()+"%'";
		}
				
		if(!tipoPersona.equals("")){
			if(!primero)
				filtro+=" AND ";
			else{ 
				primero = false;
				filtro+="WHERE ";
			}
			filtro+= "UPPER(" + P06BTablas.P06B_P06B32_CLASE + ") = '"+ tipoPersona.toUpperCase() +"'";
		}
		if(!dni.equals("")){
			if(!primero)
				filtro+=" AND ";
			else{ 
				primero = false;
				filtro+="WHERE ";
			}
			filtro+= "UPPER(" + P06BTablas.P06B_P06B32_IDENTIFICADOR + ") LIKE '%"+dni.toUpperCase()+"%'";
		}
		if(!razsoc.equals("")){
			if(!primero)
				filtro+=" AND ";
			else{ 
				primero = false;
				filtro+="WHERE ";
			}
			filtro+= "UPPER(" + P06BTablas.P06B_P06B32_RAZSOC + ") LIKE '%"+razsoc.toUpperCase()+"%'";
		}
		if(!nombre.equals("")){
			if(!primero)
				filtro+=" AND ";
			else{ 
				primero = false;
				filtro+="WHERE ";
			}
			filtro+= "UPPER(" + P06BTablas.P06B_P06B32_NOMBRE + ") LIKE '%"+nombre.toUpperCase()+"%'";
		}
		if(!ape1.equals("")){
			if(!primero)
				filtro+=" AND ";
			else{ 
				primero = false;
				filtro+="WHERE ";
			}
			filtro+= "UPPER(" + P06BTablas.P06B_P06B32_APE1 + ") LIKE '%"+ape1.toUpperCase()+"%'";
		}
		if(!ape2.equals("")){
			if(!primero)
				filtro+=" AND ";
			else{ 
				primero = false;
				filtro+="WHERE ";
			}
			filtro+= "UPPER(" + P06BTablas.P06B_P06B32_APE2 + ") LIKE '%"+ape2.toUpperCase()+"%'";
		}
		
		return filtro;
	}
}